/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.system;

import de.willuhn.jameica.messaging.QueryMessage;
import de.willuhn.jameica.security.Certificate;
import de.willuhn.jameica.security.JameicaAuthenticator;
import de.willuhn.jameica.security.Login;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.ApplicationCallback;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Level;
import de.willuhn.logging.Logger;
import java.net.InetAddress;
import javax.security.cert.X509Certificate;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractApplicationCallback
implements ApplicationCallback {
    Settings settings = new Settings(ApplicationCallback.class);
    private String hostname = null;

    @Override
    public String getHostname() throws Exception {
        if (StringUtils.trimToNull((String)this.hostname) != null) {
            return this.hostname;
        }
        this.hostname = this.settings.getString("jameica.hostname", null);
        if (this.hostname != null && this.hostname.length() > 0) {
            Logger.info((String)("using manually configured hostname: " + this.hostname));
            return this.hostname;
        }
        try {
            InetAddress a = InetAddress.getLocalHost();
            this.hostname = a.getCanonicalHostName();
            if (this.hostname == null || this.hostname.length() == 0) {
                this.hostname = a.getHostName();
            }
            if (this.hostname == null || this.hostname.length() == 0) {
                this.hostname = a.getHostAddress();
            }
            if (this.hostname != null && this.hostname.length() > 0 && !this.hostname.equals("127.0.0.1")) {
                return this.hostname;
            }
        }
        catch (Exception e) {
            Logger.warn((String)("unable to determine hostname, asking user: " + e.toString()));
            Logger.write((Level)Level.DEBUG, (String)"stacktrace for debugging purpose", (Throwable)e);
        }
        String question = Application.getI18n().tr("Der Hostname Ihres Computers konnte nicht ermittelt werden.\nBitte geben Sie ihn manuell ein. Sollten Sie ihn nicht kennen,\ndann w\u00e4hlen Sie einen beliebigen Namen. Verwenden Sie bitte\nausschliesslich Buchstaben oder Zahlen und ggf. \".\" oder \"-\"");
        String label = Application.getI18n().tr("Hostname Ihres Computers");
        this.hostname = Application.getCallback().askUser(question, label);
        this.settings.setAttribute("jameica.hostname", this.hostname);
        return this.hostname;
    }

    @Override
    public boolean checkHostname(String hostname, X509Certificate[] certs) throws Exception {
        QueryMessage msg = new QueryMessage(hostname, certs);
        Application.getMessagingFactory().getMessagingQueue("jameica.trust.hostname").sendSyncMessage(msg);
        Object data = msg.getData();
        if (data != null && data instanceof Boolean && ((Boolean)data).booleanValue()) {
            Logger.debug((String)("hostname: " + hostname + ", trusted by: " + msg.getName()));
            return true;
        }
        StringBuffer hostnames = new StringBuffer();
        for (int i = 0; i < certs.length; ++i) {
            Certificate c = new Certificate(certs[i]);
            String h = c.getSubject().getAttribute("CN");
            if (h == null || h.length() == 0) continue;
            if (i > 0) {
                hostnames.append(",");
            }
            hostnames.append(h);
        }
        String s = Application.getI18n().tr("Der Hostname \"{0}\" stimmt mit keinem der Server-Zertifikate \u00fcberein ({1}). Wollen Sie den Vorgang dennoch fortsetzen?", new String[]{hostname, hostnames.toString()});
        return this.askUser(s);
    }

    @Override
    public Login login(JameicaAuthenticator authenticator) throws Exception {
        QueryMessage msg = new QueryMessage(authenticator);
        Application.getMessagingFactory().getMessagingQueue("jameica.auth").sendSyncMessage(msg);
        Object result = msg.getData();
        if (result != null && result instanceof Login) {
            return (Login)result;
        }
        return null;
    }
}

